 ; Ŀ
 ;   Eno - change existing text or attributes to incremented numbers as    
 ;   they are selected.  Allows direct subentity selection.                
 ;   Copyright 1996, 2001, 2002 by Rocket Software Ltd.                    
 ;   Coming soon from Rocket Foods: ASCII macaroni.                        
 ; 

 ; Ŀ
 ;   Subroutine Defau - return all tiles to their default values.          
 ; 
 (DEFUN DEFAU ()
  (set_tile "start" "1")
  (set_tile "increment" "1")
  (set_tile "prefix" "")
  (set_tile "suffix" ""))
 ; Ŀ
 ;   Defau end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Enok: see whether the various edit box values are ok.      
 ;   If so and the callback was the result of an <Enter> (Reason = 1),     
 ;   then return a list of the edit box values.                            
 ;   The Ok button returns two numbers: a 2 immediately followed by a 1.   
 ;   They are interpreted sequentially - the 2 doesn't block the 1.        
 ;                                                                         
 ;   Conditions for accepting the dialog box contents:                     
 ;   1. The Start box contains a number, and                               
 ;   2. the Increment box contains a number.                               
 ;   Anything is acceptable in the prefix and suffix boxes.                
 ; 
 (DEFUN ENOK (reason / start incr typs typi prefa suffa retlst)
  (setq start (get_tile "start"))
  (setq incr (get_tile "increment"))
  (setq typs (type (read start)))
  (setq typi (type (read incr)))
  (setq prefa (get_tile "prefix"))
  (setq suffa (get_tile "suffix"))
  (cond ((not (or (= typs 'INT) (= typs 'REAL)))
         (set_tile "enotext" "Start value is not a number."))
        ((not (or (= typi 'INT) (= typi 'REAL)))
         (set_tile "enotext" "Increment value is not a number."))
        (t
         (set_tile "enotext" "")
         (if (= reason 1)
             (progn
                  (setq retlst (list start incr prefa suffa))
                  (done_dialog)))))
 retlst)
 ; Ŀ
 ;   Enok end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Enox - call a dialog box to get various values.            
 ; 
 (DEFUN ENOX (start incra prefa suffa / enolst)
  (setq dcl_id (load_dialog "eno.dcl"))
  (new_dialog "eno" dcl_id)            ; must come before data for box
  (action_tile "edit_ok" "(setq enolst (enok 1))")
  (action_tile "defaults" "(defau)")
  (action_tile "start" "(setq enolst (enok $reason))")
  (action_tile "increment" "(setq enolst (enok $reason))")
  (action_tile "prefix" "(setq enolst (enok $reason))")
  (action_tile "suffix" "(setq enolst (enok $reason))")
  (set_tile "start" start)
  (set_tile "increment" incra)
  (set_tile "prefix" prefa)
  (set_tile "suffix" suffa)
  (start_dialog)
  (unload_dialog dcl_id)
 enolst)
 ; Ŀ
 ;   Enox end.                                                             
 ; 

 ; Ŀ
 ;   Enoo - trailing zero remover.                                         
 ;   Arguments: Num, a number.                                             
 ;              Placo, the number of decimal places to look for.           
 ;   Returns a string without zeros after the decimal point.               
 ; 
 (DEFUN ENOO (num placo / strnum strnump pnum lasdig)
  (if (equal (read (rtos num 2 placo)) 0) "0"
      (progn
           (setq strnump (setq strnum (rtos num 2 placo)))
           (setq pnum strnump)        ; for while initialization
           (while (= strnump pnum)
                  (setq pnum (substr strnump 1 (1- (strlen strnump))))
                  (setq lasdig (substr strnump (strlen strnump)))
                  (if (equal lasdig "0") (setq strnump pnum)))
           (if (equal lasdig ".") pnum strnum))))
 ; Ŀ
 ;   Enoo end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Loose - takes a string as an argument, prompts for an      
 ;   entity nentsel, puts the string into the entity.                      
 ;   Returns an ename if something was selected, otherwise nil             
 ; 
 (DEFUN LOOSE (str / nent enam entt typ outer nn)
  (if (setq enam (car (setq nent (nentsel (strcat "<" str ">: ")))))
      (setq typ (cdr (assoc 0 (setq entt (entget enam))))))
  (if (and enam (or (= "TEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ)))
      (progn
           (setq outer (car (reverse (car (reverse nent)))))
           (entmod (subst (cons 1 str) (assoc 1 entt) entt))
           (entupd enam)
           (if (= (type outer) 'ENAME) (entupd outer)))
      (progn
           (if enam (write-line "Can't use that entity type."))
           (setq enam ())))
 (if enam enam ()))
 ; Ŀ
 ;   Loose end.                                                            
 ; 

 ; Ŀ
 ;   Eno - the fizzy white ups.                                            
 ; 
 (DEFUN C:ENO ( / *error* snapp)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make the new local error handler, turn off snap.                      
 ; 
  (DEFUN *error* (shk /) (setvar "snapmode" snapp) (princ))
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make defaults if there are no global values.                          
 ; 
  (if (/= (type stanum) 'REAL) (setq stanum 1.0))
  (if (/= (type incrmt) 'REAL) (setq incrmt 1.0))
  (if (/= (type pref) 'STR) (setq pref ""))
  (if (/= (type suff) 'STR) (setq suff ""))
 ; Ŀ
 ;   Call the dialog box to get new values.                                
 ; 
  (if (setq enolst (enox (rtos stanum 2) (rtos incrmt 2) pref suff))
      (progn
           (setq stanum (float (read (nth 0 enolst))))
           (setq incrmt (read (nth 1 enolst)))
           (setq pref (nth 2 enolst))
           (setq suff (nth 3 enolst))
 ; Ŀ
 ;   While entities are selected, replace their string values.             
 ; 
           (setq goon t)
           (while goon
                  (setq strnum (enoo stanum 2))
 ; Ŀ
 ;   Add the prefix and suffix, put the value into the entity.             
 ; 
                 (setq strnum (strcat pref strnum suff))
                 (if (setq goon (loose strnum))
                     (setq stanum (+ incrmt stanum))))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "snapmode" snapp)
  (command "undo" "end")
 (princ))